#version 330 core

// Input data
layout(location = 0) in vec3 vertexPosition_modelspace;
layout(location = 1) in vec2 vertexUV;
layout(location = 2) in vec3 vertexNormal_modelspace;

// Output data
out vec2 texCoord;
out vec3 LightDirection1;
out vec3 LightDirection2;
out vec3 LightDirection3;
out vec3 LightDirection4;
out vec3 LightDirection5;
out vec3 LightDirection6;
out vec3 LightDirection7;
out vec3 LightDirection8;
out vec3 ViewDirection;
out vec3 Normal;

// Values that stay constant for the whole draw.
uniform mat4 MVP;
uniform mat4 V;
uniform mat4 M;
uniform vec3 fvLightPosition1;
uniform vec3 fvLightPosition2;
uniform vec3 fvLightPosition3;
uniform vec3 fvLightPosition4;
uniform vec3 fvLightPosition5;
uniform vec3 fvLightPosition6;
uniform vec3 fvLightPosition7;
uniform vec3 fvLightPosition8;
uniform vec3 fvEyePosition;
uniform float Time;

void main(void)
{
	gl_Position =  MVP * vec4(vertexPosition_modelspace,1);
   
	texCoord = vertexUV;

	vec3 tangent;
	vec3 binormal;
   
	vec3 c1 = cross( vec4(vertexPosition_modelspace,1).xyz, vec3(0.0, 0.0, 1.0) ); 
	vec3 c2 = cross( vec4(vertexPosition_modelspace,1).xyz, vec3(0.0, 1.0, 0.0) ); 

	if( length(c1)>length(c2) )
	{
		tangent = c1;	
	}
	else
	{
		tangent = c2;	
	}


	tangent = normalize(tangent);


	binormal = cross(vec4(vertexPosition_modelspace,1).xyz, tangent); 
	binormal = normalize(binormal);

	vec4 objectPosition = V * M * vec4(vertexPosition_modelspace,1);

	Normal = vec4((transpose(inverse(V * M))) *  vec4(vertexNormal_modelspace,0)).xyz;
	vec3 nBinormal = vec4((transpose(inverse(V * M))) * vec4(binormal,0)).xyz;
	vec3 nTangent = vec4((transpose(inverse(V * M))) * vec4(tangent,0)).xyz;
   
	vec3 nLightDirection1 = (V * M * vec4(fvLightPosition1, 1)).xyz - objectPosition.xyz;
	vec3 nLightDirection2 = (V * M * vec4(fvLightPosition2, 1)).xyz - objectPosition.xyz;
	vec3 nLightDirection3 = (V * M * vec4(fvLightPosition3, 1)).xyz - objectPosition.xyz;
	vec3 nLightDirection4 = (V * M * vec4(fvLightPosition4, 1)).xyz - objectPosition.xyz;
	vec3 nLightDirection5 = (V * M * vec4(fvLightPosition5, 1)).xyz - objectPosition.xyz;
	vec3 nLightDirection6 = (V * M * vec4(fvLightPosition6, 1)).xyz - objectPosition.xyz;
	vec3 nLightDirection7 = (V * M * vec4(fvLightPosition7, 1)).xyz - objectPosition.xyz;
	vec3 nLightDirection8 = (V * M * vec4(fvLightPosition8, 1)).xyz - objectPosition.xyz;

	vec3 nViewDirection = fvEyePosition - objectPosition.xyz;
   
	ViewDirection.x = dot(nTangent, nViewDirection);
	ViewDirection.y = dot(nBinormal, nViewDirection);
	ViewDirection.z = dot(Normal, nViewDirection);
   
	LightDirection1.x = dot(nTangent, nLightDirection1);
	LightDirection1.y = dot(nBinormal, nLightDirection1);
	LightDirection1.z = dot(Normal, nLightDirection1);

	LightDirection2.x = dot(nTangent, nLightDirection2);
	LightDirection2.y = dot(nBinormal, nLightDirection2);
	LightDirection2.z = dot(Normal, nLightDirection2);

	LightDirection3.x = dot(nTangent, nLightDirection3);
	LightDirection3.y = dot(nBinormal, nLightDirection3);
	LightDirection3.z = dot(Normal, nLightDirection3);
	
	LightDirection4.x = dot(nTangent, nLightDirection4);
	LightDirection4.y = dot(nBinormal, nLightDirection4);
	LightDirection4.z = dot(Normal, nLightDirection4);
	
	LightDirection5.x = dot(nTangent, nLightDirection5);
	LightDirection5.y = dot(nBinormal, nLightDirection5);
	LightDirection5.z = dot(Normal, nLightDirection5);
	
	LightDirection6.x = dot(nTangent, nLightDirection6);
	LightDirection6.y = dot(nBinormal, nLightDirection6);
	LightDirection6.z = dot(Normal, nLightDirection6);
	
	LightDirection7.x = dot(nTangent, nLightDirection7);
	LightDirection7.y = dot(nBinormal, nLightDirection7);
	LightDirection7.z = dot(Normal, nLightDirection7);
	
	LightDirection8.x = dot(nTangent, nLightDirection8);
	LightDirection8.y = dot(nBinormal, nLightDirection8);
	LightDirection8.z = dot(Normal, nLightDirection8);
}